﻿var cas_index;
var ControlName = new Array("", "Cas1", "Cas2", "Cas3", "Cas4", "Cas5", "Cas6");
var language;
var CAS_NUM = 6;
var SC_AUTH_NUM = 0;

function CasSystemDisplay(ifIndex)
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=29&cmd=1&getCasParam=1&casIndex=" + cas_index + "&casNo=" + (ifIndex - 1);
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			var response = xmlhttp.responseText.slice(7, -8);
			var cellCount = 0;
			var ifData = response.split("&");
			var ctrlName = ControlName[ifIndex];
			var casSwitch = ctrlName + "Switch";
			var casName = ctrlName + "Name";
			var casId = ctrlName + "Id";
			var casSubId = ctrlName + "SubId";
			var casEcmChId = ctrlName + "EcmChId";
			var casMainEcmgIp = ctrlName + "MainEcmgIp";
			var casMainEcmgPort = ctrlName + "MainEcmgPort";
			var casBacEcmgIp = ctrlName + "BacEcmgIp";
			var casBacEcmgPort = ctrlName + "BacEcmgPort";
			
			/* Column - CAS Switch */
			document.getElementById(casSwitch).value = parseInt(ifData[cellCount]);
			
			/* Column - CAS Name */
			cellCount++;
			document.getElementById(casName).value = (ifData[cellCount]);
			
			/* Column - CAS ID */
			cellCount++;
			document.getElementById(casId).value = (ifData[cellCount]);

			/* Column - Sub CAS ID */
			cellCount++;
			document.getElementById(casSubId).value = ifData[cellCount];
			
			/* Column - ECM Channel ID */
			cellCount++;
			document.getElementById(casEcmChId).value = ifData[cellCount];
			
			/* Column - Main ECMG IP */
			cellCount++;
			document.getElementById(casMainEcmgIp).value = ifData[cellCount];
			
			/* Column - Main ECMG Port */
			cellCount++;
			document.getElementById(casMainEcmgPort).value = ifData[cellCount];
			
			/* Column - Backup ECMG IP */
			cellCount++;
			document.getElementById(casBacEcmgIp).value = ifData[cellCount];
			
			/* Column - Backup ECMG Port */
			cellCount++;
			document.getElementById(casBacEcmgPort).value = ifData[cellCount];
			
			ifIndex++;
			
			if(ifIndex > CAS_NUM)
			{
				document.body.style.cursor = "auto";
				window.status = "Done";
			}
			else
			{
				CasSystemDisplay(ifIndex);
			}
		}/* End of readyState */
	}/* End of onreadystatechange */
	xmlhttp.send(getParams);
	return true;
}

function CasParamDisplay()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=29&cmd=1&getNormalParam=1&casIndex=" + cas_index;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			var response = xmlhttp.responseText.slice(7, -8);
			var ifData = response.split("&");
			var cellCount = 0;
			var intData = 0;
			
			/* Column - CAS Version No. */
			intData = parseInt(ifData[cellCount]);
			document.getElementById("CasVerNo").value = intData;
			
			/* Column - EIS Switch */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("EisSwitch").value = intData;
			
			/* Column - EIS Port */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("EisPort").value = intData;
			
			/* Column - Key Cycle */
			cellCount++;
			intData = parseInt(ifData[cellCount]);
			document.getElementById("KeyCycle").value = intData;

			CasSystemDisplay(1);			
		}/* End of readyState */
	}/* End of onreadystatechange */
	xmlhttp.send(getParams);
	return true;
}

function adjustCasConfigTable()
{
	var i,j,k;
	var obj = document.getElementById("CasConfig").children[3];
	if(!+"\v1")
	{
		for(i=CAS_NUM,j=SC_AUTH_NUM; i>j; i--)
		{
			for(k=0; k<9; k++)
			obj.children[k].children[i].disabled = true;
		}
	}
	else
	{
		for(i=CAS_NUM,j=SC_AUTH_NUM; i>j; i--)
		{
			for(k=0; k<9; k++)
			obj.children[k].children[i].firstElementChild.disabled = true;
		}
	}
}

function getScAuthNum()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=29&cmd=1&getScAuthNum=1";
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			SC_AUTH_NUM = parseInt(xmlhttp.responseText.slice(7, -8));
			adjustCasConfigTable();
		}
	}
	
	xmlhttp.send(getParams);
	return true;
}

function PageLoadHandler()
{
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	DisableApply();
	
	getScAuthNum();
	CasParamDisplay();
}

function pageRefresh()
{
	PageLoadHandler();
}

window.onload = function()
{
	var args = getArgs();
	var group = args["group"];
	var apply = document.getElementById("Apply");
	applyDispay(group, apply);
	language = document.getElementById("language").value;
	nodeId = parent.curTree.getSelectedNodes()[0].id;
	var str = nodeId.toString();
	var len = str.length;
	var casVal = Math.pow(10, (len - 1));
	cas_index = parseInt(nodeId%casVal) - 1;
	PageLoadHandler();
}

function DisableApply()
{
	disabledButton(document.getElementById("Apply"), true);
}

function EnableApply()
{
	disabledButton(document.getElementById("Apply"), false);
}

function GenerateCasParam(ifIndex)
{
	var typeStr;
	var params = "";
	
	typeStr = "Switch";
	var Switch = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + Switch + "&";
	
	typeStr = "Name";
	var Name = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + Name + "&";
	
	typeStr = "Id";
	var Id = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + Id + "&";
	
	typeStr = "SubId";
	var SubId = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + SubId + "&";
	
	typeStr = "EcmChId";
	var EcmChId = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + EcmChId + "&";
	
	typeStr = "MainEcmgIp";
	var MainEcmgIp = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + MainEcmgIp + "&";

	typeStr = "MainEcmgPort";
	var MainEcmgPort = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + MainEcmgPort + "&";

	typeStr = "BacEcmgIp";
	var BacEcmgIp = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + BacEcmgIp + "&";

	typeStr = "BacEcmgPort";
	var BacEcmgPort = document.getElementById(ControlName[ifIndex] + typeStr).value;
	params = params + typeStr + ifIndex + "=" + BacEcmgPort + "&";
	
	return params;
}

function CasParamConfig()
{
	var xmlhttp = getHTTPObject();
	var params = "type=29&cmd=2&setCasParam=1&casIndex=" + cas_index + "&";
		
	for(var i = 1; i <= SC_AUTH_NUM; i++)
	{
		params = params + GenerateCasParam(i);
	}
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("CAS Configuration Updated Successfully.");
			}
			else
			{
				alert("CAS参数设置成功。");
			}
			PageLoadHandler();
		}
	}
	xmlhttp.send(params);
	return true;
}

function GenerateNormalParam()
{
	var data ;
	var typeStr;
	var params = "";
	
	typeStr = "CasVerNo";
	data = document.getElementById(typeStr).value;
	params = typeStr + "=" + data;
		
	typeStr = "EisSwitch";
	data = document.getElementById(typeStr).value;
	params = params + "&" + typeStr + "=" + data;

	typeStr = "EisPort";
	data = document.getElementById(typeStr).value;
	params = params + "&" + typeStr + "=" + data;
		
	typeStr = "KeyCycle";
	data = document.getElementById(typeStr).value;
	params = params + "&" + typeStr + "=" + data;

	return params;
}

function NormalParamConfig()
{
	var params = "type=29&cmd=2&setNormalParam=1&casIndex=" + cas_index + "&" + GenerateNormalParam();
	var xmlhttp = getHTTPObject();
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			CasParamConfig();
		}
	}
	xmlhttp.send(params);
	return true;
}

function SetCasConfig()
{
	if(ValidateAllInput() == false)
	{
		return false;
	}
	
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Applying settings, please wait...";
	NormalParamConfig();		
}

function ValidateName(obj)
{
	var cas_name = obj.value;
	if(validateName(cas_name, 0, language) == false)
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function ValidateCasId(obj)
{
	returnFlag = ValidateParam(obj, "INT_DEC_HEX", 0, 65535, "<CAS ID>", "<CAS ID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}

function ValidateSubCasId(obj)
{
	returnFlag = ValidateParam(obj, "INT_DEC_HEX", 0, 65535, "<SUB CAS ID>", "<SUB CAS ID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}

function ValidateChannelId(obj)
{
	returnFlag = ValidateParam(obj, "INT_DEC_HEX", 0, 65535, "<ECM Channel ID>", "<ECM Channel ID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}
function ValidateIP(obj)
{
	if(Validate_IPAddress(obj.value, false) == false)
	{		
		if(language == 0)
		{
			alert("Invalid IP Address. Please enter a valid IP Address.");
		}
		else
		{
			alert("无效的IP地址，请输入一个有效的IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function ValidatePort(obj)
{
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Port.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的端口号。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((obj.value < 0) || (obj.value > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Port is 0 - 65535.");
		}
		else
		{
			alert("端口号的范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function ValidateCycle(obj)
{
	if(validateNumber(obj.value) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Key Cycle.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的密钥周期。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((obj.value < 8) || (obj.value > 6500))
	{
		if(language == 0)
		{
			alert("Valid range for Key Cycle is 8 - 6500.");
		}
		else
		{
			alert("密钥周期的范围是8 - 6500。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function ValidateAllInput()
{
	var obj;
	for(var i = 1; i <= SC_AUTH_NUM; i++)
	{
		obj = document.getElementById(ControlName[i] + "Name");
		if(ValidateName(obj) == false)
		{
			return false;
		}
		
		if(ValidateCasId($("#" + ControlName[i] + "Id")) == false)
		{
			return false;
		}
		
		if(ValidateSubCasId($("#" + ControlName[i] + "SubId")) == false)
		{
			return false;
		}
		
		if(ValidateChannelId($("#" + ControlName[i] + "EcmChId")) == false)
		{
			return false;
		}
		
		obj = document.getElementById(ControlName[i] + "MainEcmgIp");
		if(ValidateIP(obj) == false)
		{
			return false;
		}

		obj = document.getElementById(ControlName[i] + "MainEcmgPort");
		if(ValidatePort(obj) == false)
		{
			return false;
		}

		obj = document.getElementById(ControlName[i] + "BacEcmgIp");
		if(ValidateIP(obj) == false)
		{
			return false;
		}

		obj = document.getElementById(ControlName[i] + "BacEcmgPort");
		if(ValidatePort(obj) == false)
		{
			return false;
		}
	}
	
	obj = document.getElementById("EisPort");
	if(ValidatePort(obj) == false)
	{
		return false;
	}
	
	obj = document.getElementById("KeyCycle");
	if(ValidateCycle(obj) == false)
	{
		return false;
	}
	
	return true;
}

